clear all;
close all;
model_definition_SIMSYS_TD1;
%% Gnration du modle
robot=bras_2D;
%% Gnration du mouvement  tudier
dt=0.001;
qini=[-10 +20]'*pi/180;
qd=[+60 +60]'*pi/180;
tf=1;
[t,q,dq,ddq]=motion_definition_min_jerk(specs,qini,qd,tf,dt);

%initialisation des couples moteurs
Tau=zeros(2,numel(t));
%forces de raction, ajouter si ncessaire
RF=zeros(4,numel(t));

%dfinition des efforts extrieurs et de la gravit
%changer ici en fonction du port de charge envisag
Fext=[0 0]'; 
g=9.81;



% apply_external_forces  subtract f_ext from a given cell array of forces
% f_out=apply_external_forces(parent,Xup,f_in,f_ext)  incorporates the
% external forces specified in f_ext into the calculations of a dynamics
% algorithm.  It does this by subtracting the contents of f_ext from an
% array of forces supplied by the calling function (f_in) and returning the
% result.  f_ext has the following format: (1) it must either be an empty
% cell array, indicating that there are no external forces, or else a cell
% array containing NB elements such that f_ext{i} is the external force
% acting on body i; (2) f_ext{i} must either be an empty array, indicating
% that there is no external force acting on body i, or else a spatial or
% planar vector (as appropriate) giving the external force expressed in
% absolute coordinates.  apply_external_forces performs the calculation
% f_out = f_in - transformed f_ext, where f_out and f_in are cell arrays of
% forces expressed in link coordinates; so f_ext has to be transformed to
% link coordinates before use.  The arguments parent and Xup contain the
% parent array and link-to-link coordinate transforms for the model to
% which the forces apply, and are used to work out the coordinate
% transforms.


%pour tracer la figure
for i=1:numel(t)
X=DK_robot_plan(q(:,i),specs);
Xout(i).X=X;
end

%%

%calcul des couples moteurs (et des actions de liaison si ncessaire)
%par dynamique inverse analytique
for i=1:numel(t)
[Tau_AN(:,i)]=ID_robot_plan(t(i),q(:,i),dq(:,i),ddq(:,i),specs,Fext,g);
end


% calcul des couples moteurs par Newton-Euler
for i=1:numel(t)
    % attention il faut replacer F_ext en spatial  a tout instant !
    F_ext_spatial=[(specs.l1*cos(q(1,i))+specs.l2*cos(q(1,i)+q(2,i)))*Fext(2)-(specs.l1*sin(q(1,i))+specs.l2*sin(q(1,i)+q(2,i)))*Fext(1) Fext(1) Fext(2)]';
[Tau_NE(:,i)]=ID( robot, q(:,i), dq(:,i), ddq(:,i), {[0 0 0]',F_ext_spatial} );
end

figure;
hold on;
plot(t,Tau_AN);
plot(t,Tau_NE);
xlabel('time (s)');% 
ylabel('Joint torques (N.m)');



legend({'Epaule_AN','Coude_AN','Epaule_NE','Coude_NE'});




%% DYNAMIQUE DIRECTE

qfd_ini=[qini;0;0];
qfd=zeros(4,numel(t));
qfd_AB=zeros(4,numel(t));
qfd(:,1)=qfd_ini;
qfd_AB(:,1)=qfd_ini;
for i=1:numel(t)-1
    qfd(:,i+1)=RungeKutta_planar_arm('FD_planar_arm',t(i),dt,qfd(:,i),specs,Fext,Tau_AN(:,i),g);
F_ext_spatial=[(specs.l1*cos(q(1,i))+specs.l2*cos(q(1,i)+q(2,i)))*Fext(2)-(specs.l1*sin(q(1,i))+specs.l2*sin(q(1,i)+q(2,i)))*Fext(1) Fext(1) Fext(2)]';
qfd_AB(:,i+1)=RungeKutta_numerique('FD_to_int',dt,qfd_AB(:,i),robot,Tau_NE(:,i),{[0 0 0]',F_ext_spatial},t(i));

end


%% TRACE
for i=1:numel(t)
Xfd=DK_robot_plan(qfd(1:2,i),specs);
Xoutfd(i).X=X;
end

%% AFFICHAGE DD

figure
hold on;
plot(t,q);
 plot(t,qfd(1:2,:));
plot(t,qfd_AB(1:2,:));
xlabel('time (s)');% 
ylabel('Joint torques (N.m)');
legend({'q1','q2','qfd_AB1','qfd_AB2',});

% [traj]=draw_planar_arm(t,Xoutfd);